<?php
$logFile = __DIR__ . '/gelluonduhogu_cron.log';
function log_message($msg) {
    global $logFile;
    file_put_contents($logFile, "[" . date('Y-m-d H:i:s') . "] $msg\n", FILE_APPEND);
}

$startTime = microtime(true);
log_message("Script started.");

// Lock file logic
$lockFile = __DIR__ . '/gelluonduhogu_cron.lock';
$lock = fopen($lockFile, 'c');
if (!$lock || !flock($lock, LOCK_EX | LOCK_NB)) {
    log_message("Another cron is still running. Exiting.");
    exit("Another cron is still running.\n");
}

include("serive/samparka.php");
include("trxupkid.php");

$currentDate = date('Ymd');
$timeInSeconds = time() % 86400;
$sequenceNumber = intval($timeInSeconds / 60);
$uniqueSequence = str_pad($sequenceNumber, 4, '0', STR_PAD_LEFT);
$bartamankalakrama = $currentDate . "10301" . $uniqueSequence;
$bartamankalakrama = $bartamankalakrama + 1;

$prathama = $bartamankalakrama;
$sesa = $currentDate . "10001" . sprintf("%04d", ceil(86400 / 60));
$tarika = date('Y-m-d H:i:s');

log_message("Checking latest atadaaidi...");
$dekhakalakrama = mysqli_query($conn,"select atadaaidi from `gelluonduhogu_trx` order by kramasankhye desc limit 1");
if (!$dekhakalakrama) {
    log_message("Query error: " . mysqli_error($conn));
}
$kaladhadi = mysqli_num_rows($dekhakalakrama);
$kalakramadhadi = mysqli_fetch_array($dekhakalakrama);

if($kaladhadi == null){
    log_message("No previous atadaaidi found. Inserting $bartamankalakrama.");
    $tathya = mysqli_query($conn,"INSERT INTO `gelluonduhogu_trx` (`atadaaidi`,`dinankavannuracisi`) VALUES ('".$bartamankalakrama."','".$tarika."')");
    if (!$tathya) log_message("Insert error: " . mysqli_error($conn));
}
else if($prathama > $kalakramadhadi['atadaaidi']){
    log_message("Truncating table and inserting $prathama.");
    $katiba = mysqli_query($conn,"TRUNCATE TABLE `gelluonduhogu_trx`");
    $tathya = mysqli_query($conn,"INSERT INTO `gelluonduhogu_trx` (`atadaaidi`,`dinankavannuracisi`) VALUES ('".$prathama."','".$tarika."')");
    if (!$tathya) log_message("Insert error: " . mysqli_error($conn));
}
else{
    $parabartikrama = $kalakramadhadi['atadaaidi'] + 1;
    log_message("Inserting incremented atadaaidi: $parabartikrama.");
    $tathya = mysqli_query($conn,"INSERT INTO `gelluonduhogu_trx` (`atadaaidi`,`dinankavannuracisi`) VALUES ('".$parabartikrama."','".$tarika."')");
    if (!$tathya) log_message("Insert error: " . mysqli_error($conn));
}

// Release lock
flock($lock, LOCK_UN);
fclose($lock);
unlink($lockFile);

$endTime = microtime(true);
$duration = round($endTime - $startTime, 3);
log_message("Script finished. Total execution time: {$duration}s\n");
?>